/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tips;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public class Configuration {
    private final ForgeConfigSpec spec;
    private final ForgeConfigSpec.ConfigValue<Integer> cycleTime;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> removedTips;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> removedNamespaces;

    public Configuration() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("The amount of time to wait before cycling the displayed tip. This is in miliseconds. 1000ms = 1s");
        this.cycleTime = builder.define("cycleTime", (Object)5000);
        builder.comment("A list of tip IDs to remove from the list. Restart is required for changes to take effect.");
        this.removedTips = builder.defineList("removedTips", new ArrayList(), s -> ResourceLocation.func_217855_b((String)((String)s)));
        builder.comment("A list of tip namespaces to remove from the list. Restart is requird for changes to take effect.");
        this.removedNamespaces = builder.defineList("removedNamespaces", new ArrayList(), s -> ResourceLocation.func_217855_b((String)((String)s)));
        this.spec = builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public int getCycleTime() {
        return (Integer)this.cycleTime.get();
    }

    public boolean canLoadTip(ResourceLocation tipId) {
        return !((List)this.removedNamespaces.get()).contains(tipId.func_110624_b()) && !((List)this.removedTips.get()).contains(tipId.toString());
    }
}

